<?php
/**
* @version    $Id: roundresult.php 61 2008-04-24 15:20:36Z julienv $ 
* @package    JoomlaTracks
* @copyright    Copyright (C) 2008 Julien Vonthron. All rights reserved.
* @license      GNU/GPL, see LICENSE.php
* Joomla Tracks is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport('joomla.application.component.model');
require_once( 'base.php' );
/**
 * Joomla Tracks Component Front page Model
 *
 * @package     Tracks
 * @since 0.1
 */
class TracksModelIndividuals extends baseModel
{   
    function getData()
    {
    	$ordering = JFactory::getApplication()->getParams('com_tracks')->get('ordering', 0);
    	$order = $ordering ? ' ORDER BY i.first_name, i.last_name ASC ' : ' ORDER BY i.last_name ASC, i.first_name ASC ';
        $query =  ' SELECT i.id, i.first_name, i.last_name, i.country_code, '
        . ' CASE WHEN CHAR_LENGTH( i.alias ) THEN CONCAT_WS( \':\', i.id, i.alias ) ELSE i.id END AS slug '
        . ' FROM #__tracks_individuals as i '
        . $order;

        $this->_db->setQuery( $query );
        
        return $this->_db->loadObjectList();
    }
}
