<?php
/**
 * @package     Tracks.library
 * @subpackage  Entity
 * @copyright   Tracks (C) 2008-2015 Julien Vonthron. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

/**
 * Event result Entity.
 *
 * @since  __deploy_version__
 */
class TrackslibEntityEventresult extends TrackslibEntityBase
{
	/**
	 * @var bool true if the entity supports custom field
	 */
	protected $hasCustomFields = true;

	/**
	 * Return project type
	 *
	 * @return TrackslibEntityEvent
	 */
	public function getEvent()
	{
		$item = $this->loadItem();

		if (!$item)
		{
			return false;
		}

		return TrackslibEntityEvent::load($item->event_id);
	}

	/**
	 * Return individual
	 *
	 * @return TrackslibEntityIndividual
	 */
	public function getIndividual()
	{
		$item = $this->loadItem();

		if (!$item)
		{
			return false;
		}

		return TrackslibEntityIndividual::load($item->individual_id);
	}

	/**
	 * Return team
	 *
	 * @return TrackslibEntityTeam
	 */
	public function getTeam()
	{
		$item = $this->loadItem();

		if (!$item)
		{
			return false;
		}

		return TrackslibEntityTeam::load($item->team_id);
	}
}
