<?php
/**
 * @package     Tracks
 * @subpackage  Admin
 * @copyright   Tracks (C) 2008-2015 Julien Vonthron. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

use Joomla\CMS\Language\Text;

defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.keepalive');
JHtml::_('rdropdown.init');
JHtml::_('rbootstrap.tooltip');
JHtml::_('rjquery.chosen', 'select');

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));

$user = JFactory::getUser();
$userId = $user->id;
$search = $this->state->get('filter.search');
?>
<script type="text/javascript">
	(function($){
		$(function() {
			Joomla.submitbutton = function (pressbutton)
			{
				submitbutton(pressbutton);
			}

			submitbutton = function (pressbutton)
			{
				var form = document.adminForm;
				if (pressbutton)
				{
					form.task.value = pressbutton;
				}

				if (pressbutton == 'participants.delete')
				{
					var r = confirm('<?php echo JText::_("COM_TRACKS_DELETE_CONFIRM")?>');
					if (r == true)    form.submit();
					else return false;
				}
				form.submit();
			}

			$('button[data-start-import]').click(function() {
				$('#importForm').submit();
			});
		})
	})(jQuery);
</script>
<form action="index.php?option=com_tracks&view=participants" class="admin" id="adminForm" method="post" name="adminForm">
	<?php
	echo RLayoutHelper::render(
		'searchtools.default',
		array(
			'view' => $this,
			'options' => array(
				'searchField' => 'search',
				'searchFieldSelector' => '#filter_search',
				'limitFieldSelector' => '#list_fields_limit',
				'activeOrder' => $listOrder,
				'activeDirection' => $listDirn
			)
		)
	);
	?>
	<hr />
	<?php if (empty($this->items)) : ?>
		<div class="alert alert-info">
			<button type="button" class="close" data-dismiss="alert">&times;</button>
			<div class="pagination-centered">
				<h3><?php echo JText::_('COM_TRACKS_NOTHING_TO_DISPLAY'); ?></h3>
			</div>
		</div>
	<?php else : ?>
		<table class="table table-striped" id="table-items">
			<thead>
			<tr>
				<th width="10" align="center">
					<?php echo '#'; ?>
				</th>
				<th width="10">
					<?php if (version_compare(JVERSION, '3.0', 'lt')) : ?>
						<input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this);" />
					<?php else : ?>
						<?php echo JHTML::_('grid.checkall'); ?>
					<?php endif; ?>
				<?php if ($this->canEdit) : ?>
					<th width="1" nowrap="nowrap">
					</th>
				<?php endif; ?>
				<th width="10">
					<?php echo JHTML::_('rsearchtools.sort', 'COM_TRACKS_NUMBER', 'obj.number', $listDirn, $listOrder); ?>
				</th>
				<th class="title" width="auto">
					<?php echo JHTML::_('rsearchtools.sort', 'COM_TRACKS_NAME', 'i.last_name', $listDirn, $listOrder); ?>
				</th>
				<th class="title" width="auto">
					<?php echo JHTML::_('rsearchtools.sort', 'COM_TRACKS_TEAM', 't.name', $listDirn, $listOrder); ?>
				</th>
			</tr>
			</thead>
			<tbody>
			<?php $n = count($this->items); ?>
			<?php foreach ($this->items as $i => $row) : ?>
				<?php $orderkey = array_search($row->id, $this->ordering[0]); ?>
				<tr>
					<td>
						<?php echo $this->pagination->getRowOffset($i); ?>
					</td>
					<td>
						<?php echo JHtml::_('grid.id', $i, $row->id); ?>
					</td>
					<?php if ($this->canEdit) : ?>
						<td>
							<?php if ($row->checked_out) : ?>
								<?php
								$editor = JFactory::getUser($row->checked_out);
								$canCheckin = $user->authorise('core.manage', 'com_checkin') || $row->checked_out == $userId || $row->checked_out == 0;
								echo JHtml::_('rgrid.checkedout', $i, $editor->name, $row->checked_out_time, 'participants.', $canCheckin);
								?>
							<?php endif; ?>
						</td>
					<?php endif; ?>
					<td>
						<?php echo $row->number; ?>
					</td>
					<td>
						<?php $itemTitle = $row->last_name. ', ' . $row->first_name; ?>
						<?php if (($row->checked_out) || (!$this->canEdit)) : ?>
							<?php echo $itemTitle; ?>
						<?php else : ?>
							<?php echo JHtml::_('link', 'index.php?option=com_tracks&task=participant.edit&id=' . $row->id, $itemTitle); ?>
						<?php endif; ?>
					</td>
					<td>
						<?php echo $row->team; ?>
					</td>
				</tr>
			<?php endforeach; ?>
			</tbody>
		</table>
		<?php echo $this->pagination->getPaginationLinks(null, array('showLimitBox' => false)); ?>
	<?php endif; ?>
	<input type="hidden" name="task" value=""/>
	<input type="hidden" name="boxchecked" value="0"/>
	<?php echo JHtml::_('form.token'); ?>
</form>

<div class="modal fade" id="importfrom-modal" tabindex="-1" role="dialog" aria-labelledby="importfromLabel">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title" id="importfromLabel">
					<?= Text::_('COM_TRACKS_PARTICIPANTS_IMPORT_FROM_TITLE') ?>
				</h4>
			</div>
			<div class="modal-body">
				<form action="index.php?option=com_tracks" id="importForm" method="post">
					<select id="source" name="source">
						<?php foreach ($this->projectsList as $project): ?>
							<option value="<?= $project->id ?>"><?= $project->name ?></option>
						<?php endforeach; ?>
					</select>

					<input type="hidden" name="task" value="participants.copyfrom"/>
					<input type="hidden" name="destination" value="<?= TrackslibHelperTools::getCurrentProjectId() ?>"/>
					<?php echo JHtml::_('form.token'); ?>
				</form>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">
					<?= Text::_('JTOOLBAR_CLOSE') ?>
				</button>
				<button type="button" class="btn btn-primary" data-start-import>
					<?= Text::_('COM_TRACKS_PARTICIPANTS_IMPORT_FROM_IMPORT') ?>
				</button>
			</div>
		</div>
	</div>
</div>