<?php
/**
 * @package     Tracks.library
 * @subpackage  Entity
 * @copyright   Tracks (C) 2008-2015 Julien Vonthron. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

use Joomla\CMS\Factory;
use Tracks\Rankingtool\RankingtoolInterface;

defined('_JEXEC') or die;

/**
 * Project Entity.
 *
 * @property integer $id
 * @property integer $competition_id
 * @property integer $season_ids
 *
 * @since  3.0
 */
class TrackslibEntityProject extends TrackslibEntityBase
{
	/**
	 * @var RankingtoolInterface
	 */
	protected $rankingTool;

	/**
	 * @var array
	 */
	private $projectRounds;

	/**
	 * Return project type
	 *
	 * @return boolean|mixed
	 */
	public function getProjectType()
	{
		return $this->type;
	}

	/**
	 * Get ranking tool for project
	 *
	 * @return RankingtoolInterface
	 */
	public function getRankingTool()
	{
		if (empty($this->rankingTool))
		{
			JPluginHelper::importPlugin('tracks_projecttype');
			RFactory::getDispatcher()->trigger('onTracksGetRankingTool', array($this->id, &$this->rankingTool));
		}

		return clone $this->rankingTool;
	}

	/**
	 * Get competition
	 *
	 * @return TrackslibEntityCompetition
	 */
	public function getCompetition ()
	{
		return TrackslibEntityCompetition::load($this->competition_id);
	}

	/**
	 * Get season
	 *
	 * @return TrackslibEntitySeason
	 */
	public function getSeason ()
	{
		return TrackslibEntitySeason::load($this->season_id);
	}

	/**
	 * Get project rounds
	 *
	 * @return array|TrackslibEntityBase
	 */
	public function getProjectRounds()
	{
		if (!is_null($this->projectRounds))
		{
			return $this->projectRounds;
		}

		$db = Factory::getDbo();
		$query = $db->getQuery(true)
			->select('*')
			->from('#__tracks_projects_rounds')
			->where('project_id = ' . (int) $this->id);

		$db->setQuery($query);
		$items = $db->loadObjectList();

		$this->projectRounds = TrackslibEntityProjectround::loadArray($items);

		return $this->projectRounds;
	}
}
