<?php
/**
 * @package     Tracks.library
 * @subpackage  Entity
 * @copyright   Tracks (C) 2008-2015 Julien Vonthron. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

/**
 * Participant Entity.
 *
 * @property int  $id
 * @property int  $participant_id
 * @property int  $individual_id
 * @property int  $role_id
 *
 * @since  __deploy_version__
 */
class TrackslibEntityParticipant_individual extends TrackslibEntityBase
{
	/**
	 * Override name
	 *
	 * @param   string  $name  table name
	 *
	 * @return JTable|RTable
	 */
	protected function getTable($name = null)
	{
		if (null === $name)
		{
			$name = "Participants_individuals";
		}

		$name = str_replace('Entity', '', $name);

		return RTable::getAdminInstance($name, array(), $this->getComponent());
	}

	/**
	 * Get participant
	 *
	 * @return boolean|TrackslibEntityIndividual
	 */
	public function getParticipant()
	{
		if (!$this->hasId())
		{
			return false;
		}

		return TrackslibEntityParticipant::load($this->participant_id);
	}

	/**
	 * Get individual
	 *
	 * @return boolean|TrackslibEntityIndividual
	 */
	public function getIndividual()
	{
		if (!$this->hasId())
		{
			return false;
		}

		return TrackslibEntityIndividual::load($this->individual_id);
	}

	/**
	 * Get role
	 *
	 * @return boolean|TrackslibEntityParticipant_role
	 */
	public function getRole()
	{
		if (!$this->hasId() || empty($this->role_id))
		{
			return false;
		}

		return TrackslibEntityParticipant_role::load($this->role_id);
	}

	/**
	 * Get name from first and last name
	 *
	 * @return string
	 */
	public function getFullName()
	{
		return $this->getIndividual()->getFullName();
	}
}
