<?php
/**
 * @package     Tracks
 * @subpackage  Install
 * @copyright   Tracks (C) 2008-2015 Julien Vonthron. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die('Restricted access');

// Find redCORE installer to use it as base system
if (!class_exists('Com_RedcoreInstallerScript'))
{
	$searchPaths = array(
		// Install
		dirname(__FILE__) . '/redCORE',
		// Discover install
		JPATH_ADMINISTRATOR . '/components/com_redcore'
	);

	if ($redcoreInstaller = JPath::find($searchPaths, 'install.php'))
	{
		require_once $redcoreInstaller;
	}
	else
	{
		exit('COM_TRACKS_INSTALLER_ERROR_REDCORE_IS_REQUIRED');
		throw new Exception(JText::_('COM_TRACKS_INSTALLER_ERROR_REDCORE_IS_REQUIRED'), 500);
	}
}

/**
 * Custom installation of Tracks.
 *
 * @package     Redevent
 * @subpackage  Install
 * @since       3.0
 */
class Com_TracksInstallerScript extends Com_RedcoreInstallerScript
{
	/**
	 * Called after any type of action
	 *
	 * @param   string  $route  Which action is happening (install|uninstall|discover_install|update)
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function postflight($route, JAdapterInstance $adapter)
	{
		Factory::getApplication()->enqueueMessage(
			Text::sprintf('COM_TRACKS_POST_FLIGHT', 'index.php?option=com_tracks&view=about')
		);
	}
}
